-- ================================================================
--
-- @version $Id: structure.sql 2011-05-25 10:12:05 gewa $
-- @package Digital Downloads Pro
-- @copyright 2011.
--
-- ================================================================
-- Database structure
-- ================================================================

--
-- Table structure for table `cart`
--

CREATE TABLE IF NOT EXISTS `cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `price` float(7,2) DEFAULT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `categories`
--

CREATE TABLE IF NOT EXISTS `categories` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `parent_id` int(5) NOT NULL DEFAULT '0',
  `slug` varchar(200) NOT NULL,
  `description` text,
  `position` tinyint(2) NOT NULL DEFAULT '0',
  `metakeys` text NOT NULL,
  `metadesc` text NOT NULL,
  `active` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `comments`
--

CREATE TABLE IF NOT EXISTS `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(24) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `body` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `www` varchar(220) DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(16) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `comments_config`
--

CREATE TABLE IF NOT EXISTS `comments_config` (
  `username_req` tinyint(1) NOT NULL,
  `email_req` tinyint(1) NOT NULL,
  `show_captcha` tinyint(1) NOT NULL,
  `show_www` tinyint(1) NOT NULL,
  `show_username` tinyint(1) NOT NULL,
  `show_email` tinyint(1) NOT NULL,
  `auto_approve` tinyint(1) NOT NULL,
  `notify_new` tinyint(1) NOT NULL,
  `public_access` tinyint(1) NOT NULL,
  `sorting` char(4) NOT NULL,
  `blacklist_words` text NOT NULL,
  `char_limit` smallint(4) NOT NULL,
  `perpage` tinyint(2) NOT NULL,
  `dateformat` char(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `comments_config`
--

INSERT INTO `comments_config` (`username_req`, `email_req`, `show_captcha`, `show_www`, `show_username`, `show_email`, `auto_approve`, `notify_new`, `public_access`, `sorting`, `blacklist_words`, `char_limit`, `perpage`, `dateformat`) VALUES
(1, 1, 1, 1, 1, 0, 0, 1, 1, 'DESC', 'arse\narses\nass\nasses\nbollocks\ncrap', 300, 5, '%a %d, %M %Y');

--
-- Table structure for table `coupons`
--

CREATE TABLE IF NOT EXISTS `coupons` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `code` varchar(100) NOT NULL,
  `discount` varchar(4) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `minval` decimal(10,2) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `email_templates`
--

CREATE TABLE IF NOT EXISTS `email_templates` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `help` text,
  `body` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `email_templates`
--

INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES
(1, 'Registration Email', 'Please verify your email', 'This template is used to send Registration Verification Email, when Configuration-&gt;Registration Verification is set to YES', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Welcome [NAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Hello, &lt;br/&gt;&lt;br/&gt;\n          You&#039;re now a member of [SITE_NAME]. &lt;br/&gt;\n          Here are your login details. Please keep them in a safe place:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[USERNAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Password:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PASSWORD] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;The administrator of this site has requested all new accounts\n          to be activated by the users who created them thus your account\n          is currently inactive. &lt;br/&gt;To activate your account,\n          please visit the link below and enter the following:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Token:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[TOKEN]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Email:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[EMAIL] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;a href=&quot;[LINK]&quot;&gt;&lt;strong&gt;Click here to activate your account&lt;/strong&gt;&lt;/a&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(2, 'Forgot Password Email', 'Password Reset', 'This template is used for retrieving lost user password', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;New password reset from [SITE_NAME]!&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Hello, &lt;strong&gt;[USERNAME]&lt;/strong&gt;&lt;br/&gt;\n          &lt;br/&gt;\n          It seems that you or someone requested a new password for you.&lt;br/&gt;\n          We have generated a new password, as requested:&lt;br/&gt;\n          &lt;br/&gt;\n          Your new password: &lt;strong&gt;[PASSWORD]&lt;/strong&gt;&lt;br/&gt;\n          &lt;br/&gt;\n          To use the new password you need to activate it. To do this click the link provided below and login with your new password.&lt;br/&gt;\n          &lt;a href=&quot;[LINK]&quot;&gt;[LINK]&lt;/a&gt;&lt;br/&gt;\n          &lt;br/&gt;\n          You can change your password after you sign in.\n          &lt;hr/&gt;\n          Password requested from IP: [IP]&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(3, 'Welcome Mail From Admin', 'You have been registered', 'This template is used to send welcome email, when user is added by administrator', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Welcome [NAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Hello, &lt;br/&gt;\n          &lt;br/&gt;\n          You&#039;re now a member of [SITE_NAME]. &lt;br/&gt;\n          Here are your login details. Please keep them in a safe place:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[USERNAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Password:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PASSWORD] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(4, 'Default Newsletter', 'Newsletter', 'This is a default newsletter template', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello [NAME]!&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;You are receiving this email as a part of your newsletter subscription.&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt; Here goes your newsletter content... &lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;background-color:#f1f1f1;border-top-width:2px; border-top-color:#fff; border-top-style:solid&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;To stop receiving future newsletters please login into your account         and uncheck newsletter subscription box.&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(5, 'Transaction Completed', 'Payment Completed', 'This template is used to notify administrator on successful payment transaction', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello, Admin&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left&quot;&gt;You have received new payment transaction:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[USERNAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Status:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[STATUS] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Amount:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[TOTAL] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Processor:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PP] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;IP:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[IP] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;&lt;strong&gt;You can view this transaction from your admin panel.&lt;/strong&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(6, 'Transaction Suspicious', 'Suspicious Transaction', 'This template is used to notify administrator on failed/suspicious payment transaction', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello, Admin&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left&quot;&gt;The following transaction has been disabled due to suspicious activity:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;\n              &lt;tr&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[USERNAME]&lt;/td&gt;\n              &lt;/tr&gt;\n              &lt;tr&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Status:&lt;/strong&gt;&lt;/td&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[STATUS] &lt;/td&gt;\n              &lt;/tr&gt;\n              &lt;tr&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Amount:&lt;/strong&gt;&lt;/td&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[TOTAL] &lt;/td&gt;\n              &lt;/tr&gt;\n              &lt;tr&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Processor:&lt;/strong&gt;&lt;/td&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PP] &lt;/td&gt;\n              &lt;/tr&gt;\n              &lt;tr&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;IP:&lt;/strong&gt;&lt;/td&gt;\n                &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[IP] &lt;/td&gt;\n              &lt;/tr&gt;\n            &lt;/tbody&gt;\n          &lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Please verify this transaction is correct.  It appears that someone tried to fraudulently obtain products from your site.&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(7, 'Welcome Email', 'Welcome', 'This template is used to welcome newly registered user when Configuration-&gt;Registration Verification and Configuration-&gt;Auto Registration are both set to YES', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Welcome [NAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Hello, &lt;br/&gt;\n          &lt;br/&gt;\n          You&#039;re now a member of [SITE_NAME]. &lt;br/&gt;\n          Here are your login details. Please keep them in a safe place:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[USERNAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Password:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PASSWORD] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(8, 'Transaction Completed User', 'Transaction Completed', 'This template is used to notify user on successful purchase.', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello [USERNAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;You have purchased the following:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;[ITEMS]&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;You can now download your item(s) from your control panel.&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(9, 'Notify User Transaction', 'Your product is ready for download', 'This template is used to notify user when manual transaction has been processed.', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello [USERNAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Your product is ready for download:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Product:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[ITEMNAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Price:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PRICE] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Quantity:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[QTY] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;You can now download your item(s) from your control panel.&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(10, 'Contact Request', 'Contact Inquiry', 'This template is used to send default Contact Request Form', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello, Admin&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left&quot;&gt;You have received new contact request:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;From:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[SENDER] - [NAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Subject:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[MAILSUBJECT] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;IP:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[IP] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td colspan=&quot;2&quot; style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;left&quot; valign=&quot;top&quot;&gt;[MESSAGE]&lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(12, 'Single Email', 'Single User Email', 'This template is used to email single user', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello [NAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Your message goes here...&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(13, 'Notify Admin', 'New User Registration', 'This template is used to notify admin of new registration when Configuration-&gt;Registration Notification is set to YES', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello Admin&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;You have a new user registration:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[SENDER] - [NAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Name:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[WWW] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;IP:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[IP] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;You can login into your admin panel to view details.&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(14, 'Registration Pending', 'Registration Verification Pending', 'This template is used to send Registration Verification Email, when Configuration-&gt;Auto Registration is set to NO', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Welcome [NAME]&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;Hello, &lt;br/&gt;\n          &lt;br/&gt;\n          You&#039;re now a member of [SITE_NAME]. &lt;br/&gt;\n          Here are your login details. Please keep them in a safe place:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;Username:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[USERNAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Password:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[PASSWORD] &lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;The administrator of this site has requested all new accounts\n          to be activated by the users who created them thus your account\n          is currently pending verification process.&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;&lt;em&gt;Thanks,&lt;br/&gt;\n          [SITE_NAME] Team&lt;br/&gt;\n          &lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/em&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;'),
(11, 'New Comment', 'New Comment Added', 'This template is used to notify admin when new comment has been added.', '&lt;div style=&quot;font-family:Arial, Helvetica, sans-serif; font-size:13px;margin:20px&quot; align=&quot;center&quot;&gt;\n  &lt;table style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 2px solid #bbb;&quot; border=&quot;0&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot; width=&quot;600&quot;&gt;\n    &lt;tbody&gt;\n      &lt;tr&gt;\n        &lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;Hello Admin&lt;/th&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;You have a new comment post:&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n            &lt;tbody&gt;&lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;&lt;strong&gt;From:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[SENDER] - [NAME]&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;www:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[WWW] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;Product Url:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;&lt;a href=&quot;[PAGEURL]&quot;&gt;[PAGEURL]&lt;/a&gt;&lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;&lt;strong&gt;IP:&lt;/strong&gt;&lt;/td&gt;\n              &lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;[IP] &lt;/td&gt;\n            &lt;/tr&gt;\n            &lt;tr&gt;\n              &lt;td colspan=&quot;2&quot; style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;left&quot;&gt;{MESSAGE]&lt;/td&gt;\n            &lt;/tr&gt;\n          &lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;\n      &lt;/tr&gt;\n      &lt;tr&gt;\n        &lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;You can login into your admin panel to view details&lt;/td&gt;\n      &lt;/tr&gt;\n    &lt;/tbody&gt;\n  &lt;/table&gt;\n&lt;/div&gt;');

--
-- Table structure for table `extras`
--

CREATE TABLE IF NOT EXISTS `extras` (
  `user_id` varchar(50) NOT NULL DEFAULT '0',
  `coupon` decimal(10,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `faq`
--

CREATE TABLE IF NOT EXISTS `faq` (
  `id` tinyint(3) NOT NULL AUTO_INCREMENT,
  `question` varchar(150) DEFAULT NULL,
  `answer` text,
  `position` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `files`
--

CREATE TABLE IF NOT EXISTS `files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `filesize` varchar(80) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `gateways`
--

CREATE TABLE IF NOT EXISTS `gateways` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `displayname` varchar(200) NOT NULL,
  `dir` varchar(200) NOT NULL,
  `demo` tinyint(1) NOT NULL DEFAULT '1',
  `extra_txt` varchar(200) NOT NULL,
  `extra_txt2` varchar(200) NOT NULL,
  `extra_txt3` varchar(200) DEFAULT NULL,
  `extra` varchar(200) NOT NULL,
  `extra2` varchar(200) NOT NULL,
  `extra3` varchar(200) DEFAULT NULL,
  `info` text,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `gateways`
--

INSERT INTO `gateways` (`id`, `name`, `displayname`, `dir`, `demo`, `extra_txt`, `extra_txt2`, `extra_txt3`, `extra`, `extra2`, `extra3`, `info`, `active`) VALUES
(1, 'paypal', 'PayPal', 'paypal', 0, 'Paypal Email Address', 'Currency Code', 'Not in Use', 'paypal@address.com', 'CAD', '', '&lt;p&gt;&lt;a href=&quot;http://www.paypal.com/&quot; title=&quot;PayPal&quot; rel=&quot;nofollow&quot; target=&quot;_blank&quot;&gt;Click here to setup an account with Paypal&lt;/a&gt; &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n			If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Paypal email address&lt;/strong&gt; - Enter your PayPal Business email address here. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Currency Code&lt;/strong&gt; - Enter your currency code here. Valid choices are: &lt;/p&gt;\r\n				&lt;ul&gt;\r\n					&lt;li&gt; USD (U.S. Dollar)&lt;/li&gt;\r\n					&lt;li&gt; EUR (Euro) &lt;/li&gt;\r\n					&lt;li&gt; GBP (Pound Sterling) &lt;/li&gt;\r\n					&lt;li&gt; CAD (Canadian Dollar) &lt;/li&gt;\r\n					&lt;li&gt; JPY (Yen). &lt;/li&gt;\r\n					&lt;li&gt; If omitted, all monetary fields will use default system setting Currency Code. &lt;/li&gt;\r\n				&lt;/ul&gt;\r\n			&lt;p&gt;&lt;strong&gt;Not in Use&lt;/strong&gt; - This field it&#039;s not in use. Leave it empty. &lt;/p&gt;\r\n	        &lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - If using recurring payment method, you need to set up and activate the IPN Url in your account: &lt;/p&gt;', 1),
(2, 'moneybookers', 'MoneyBookers', 'moneybookers', 0, 'MoneyBookers Email Address', 'Currency Code', 'Secret Passphrase', 'moneybookers@address.com', 'EUR', 'mypassphrase', '&lt;p&gt;&lt;a href=&quot;http://www.moneybookers.com/&quot; title=&quot;http://www.moneybookers.net/&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with MoneyBookers&lt;/a&gt;&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n			If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - MoneyBookers does not have demo mode. You need to open testing acounts. One seller and one buyer. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;MoneyBookers email address&lt;/strong&gt; - Enter your MoneyBookers email address here. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Secret Passphrase&lt;/strong&gt; - This field must be set at Moneybookers.com.&lt;/p&gt;\r\n	        &lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - If using recurring payment method, you need to set up and activate the IPN Url in your account: &lt;/p&gt;', 1),
(3, 'alertpay', 'AlertPay', 'alertpay', 0, 'AlertPay Email Address', 'Currency Code', 'IPN Security Code', 'alertpay@address.com', 'USD', 'd5vL9oYTOGpmVM6q', '&lt;p&gt;&lt;a href=&quot;http://www.alertpay.com/&quot; title=&quot;http://www.alertpay.net/&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with AlertPay&lt;/a&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n  If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;AlertPay email address&lt;/strong&gt; - Enter your AlertPay email address here. &lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;IPN Security Code&lt;/strong&gt; - This code needs to be generated in your AlertPay control panel.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - This has to be set in the AlertPay control panel. You will also need to check the &quot;IPN Status&quot; to enabled.&lt;/p&gt;', 1);

--
-- Table structure for table `menus`
--

CREATE TABLE IF NOT EXISTS `menus` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `page_id` tinyint(2) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `content_type` varchar(20) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `target` enum('_self','_blank') NOT NULL DEFAULT '_blank',
  `position` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `content_id` (`active`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `news`
--

CREATE TABLE IF NOT EXISTS `news` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `body` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `author` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `created` date NOT NULL DEFAULT '0000-00-00',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `pages`
--

CREATE TABLE IF NOT EXISTS `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `slug` varchar(50) NOT NULL,
  `body` longtext,
  `created` datetime NOT NULL,
  `contact` tinyint(1) NOT NULL DEFAULT '0',
  `faq` tinyint(1) NOT NULL DEFAULT '0',
  `home_page` tinyint(1) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `photos`
--

CREATE TABLE IF NOT EXISTS `photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `caption` varchar(150) NOT NULL,
  `thumb` varchar(80) NOT NULL,
  `ordering` varchar(3) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `products`
--

CREATE TABLE IF NOT EXISTS `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `title` varchar(150) NOT NULL,
  `slug` varchar(150) NOT NULL,
  `price` decimal(7,2) NOT NULL DEFAULT '0.00',
  `description` text,
  `body` text,
  `file_id` int(5) NOT NULL,
  `thumb` varchar(50) DEFAULT NULL,
  `audio` varchar(50) DEFAULT NULL,
  `youtube` varchar(200) DEFAULT NULL,
  `expiry` varchar(6) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `hits` mediumint(6) NOT NULL DEFAULT '0',
  `vote_up` int(6) DEFAULT '0',
  `vote_down` int(6) DEFAULT '0',
  `rating` int(6) NOT NULL DEFAULT '0',
  `metakeys` text,
  `metadesc` text,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `index` (`title`,`body`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `recent`
--

CREATE TABLE IF NOT EXISTS `recent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `user_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `settings`
--

CREATE TABLE IF NOT EXISTS `settings` (
  `site_name` varchar(100) NOT NULL,
  `company` varchar(100) NOT NULL,
  `site_url` varchar(150) NOT NULL,
  `site_email` varchar(50) NOT NULL,
  `seo` tinyint(1) NOT NULL DEFAULT '0',
  `perpage` tinyint(4) NOT NULL DEFAULT '10',
  `backup` varchar(25) NOT NULL,
  `thumb_w` varchar(3) NOT NULL,
  `thumb_h` varchar(3) NOT NULL,
  `img_w` varchar(5) NOT NULL,
  `img_h` varchar(5) NOT NULL,
  `file_dir` varchar(200) DEFAULT NULL,
  `short_date` varchar(50) NOT NULL,
  `long_date` varchar(50) NOT NULL,
  `dtz` varchar(120) DEFAULT NULL,
  `featured` varchar(2) NOT NULL DEFAULT '10',
  `popular` varchar(2) NOT NULL DEFAULT '6',
  `free_allowed` tinyint(1) NOT NULL DEFAULT '0',
  `offline` tinyint(1) NOT NULL DEFAULT '0',
  `logo` varchar(100) DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `cur_symbol` varchar(2) DEFAULT NULL,
  `reg_verify` tinyint(1) NOT NULL DEFAULT '1',
  `auto_verify` tinyint(1) NOT NULL DEFAULT '1',
  `reg_allowed` tinyint(1) NOT NULL DEFAULT '1',
  `user_limit` int(6) NOT NULL DEFAULT '0',
  `notify_admin` tinyint(1) NOT NULL DEFAULT '0',
  `metakeys` text,
  `metadesc` text,
  `analytics` text,
  `mailer` enum('PHP','SMTP') DEFAULT NULL,
  `smtp_host` varchar(150) DEFAULT NULL,
  `smtp_user` varchar(50) DEFAULT NULL,
  `smtp_pass` varchar(50) DEFAULT NULL,
  `smtp_port` tinyint(3) DEFAULT NULL,
  `version` varchar(10) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`site_name`, `company`, `site_url`, `site_email`, `seo`, `perpage`, `backup`, `thumb_w`, `thumb_h`, `img_w`, `img_h`, `file_dir`, `short_date`, `long_date`, `dtz`, `featured`, `popular`, `free_allowed`, `offline`, `logo`, `currency`, `cur_symbol`, `reg_verify`, `auto_verify`, `reg_allowed`, `user_limit`, `notify_admin`, `metakeys`, `metadesc`, `analytics`, `mailer`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `version`) VALUES('', '', '', '', 0, 10, '', '110', '150', '450', '600', '', '%d %b %Y', '%a %d, %M %Y', 'America/Toronto', '12', '6', 1, 0, 'logo.png', 'CAD', '$', 1, 1, 1, 0, 1, 'metakeys, separated,by coma', 'Your website description goes here', '', 'PHP', 'mail.hostname.com', 'yourusername', 'yourpass', 25, '2.00');

--
-- Table structure for table `tags`
--

CREATE TABLE IF NOT EXISTS `tags` (
  `pid` int(11) NOT NULL DEFAULT '0',
  `tag` varchar(255) NOT NULL,
  KEY `idx_content_id` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `transactions`
--

CREATE TABLE IF NOT EXISTS `transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `txn_id` varchar(50) NOT NULL,
  `pid` int(11) DEFAULT NULL,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `downloads` int(11) unsigned DEFAULT '0',
  `file_date` int(11) unsigned DEFAULT NULL,
  `ip` text,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payer_email` varchar(75) DEFAULT NULL,
  `payer_status` varchar(50) DEFAULT NULL,
  `item_qty` int(11) NOT NULL DEFAULT '1',
  `price` decimal(9,2) NOT NULL DEFAULT '0.00',
  `mc_fee` decimal(9,2) NOT NULL DEFAULT '0.00',
  `currency` char(3) DEFAULT NULL,
  `pp` varchar(40) DEFAULT NULL,
  `memo` text,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(80) NOT NULL,
  `fname` varchar(100) NOT NULL,
  `lname` varchar(100) NOT NULL,
  `email` varchar(150) NOT NULL,
  `newsletter` tinyint(1) NOT NULL DEFAULT '0',
  `cookie_id` varchar(50) NOT NULL DEFAULT '0',
  `token` varchar(50) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT '0000-00-00 00:00:00',
  `lastlogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastip` varchar(16) DEFAULT NULL,
  `userlevel` tinyint(1) NOT NULL DEFAULT '1',
  `active` enum('y','n','t','b') NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;